﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace IPBL
{
    public static class Arts
    {
        public static Bitmap sepia(ref Bitmap bmp)
        {
            BitmapData data = bmp.LockBits(new Rectangle(0, 0, bmp.Width, bmp.Height), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
            int width = data.Width, height = data.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            BitmapData newdata = bmpnew.LockBits(new Rectangle(0, 0, bmpnew.Width, bmpnew.Height), ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);

            unsafe
            {
                byte* startbit = (byte*)data.Scan0;
                byte* newdatastartbit = (byte*)newdata.Scan0;

                for (int i = 0; i < height; i++)
                {
                    for (int j = 0; j < width; j++)
                    {
                        byte r = startbit[2];
                        byte g = startbit[1];
                        byte b = startbit[0];

                        newdatastartbit[2] = r > (byte)206 ? (byte)255 : (byte)(r + 49);
                        newdatastartbit[1] = g < (byte)14 ? (byte)0 : (byte)(g - 14);
                        newdatastartbit[0] = b < (byte)56 ? (byte)0 : (byte)(b - 56);

                        startbit += 3;
                        newdatastartbit += 3;
                    }
                    startbit += data.Stride - (data.Width * 3);
                    newdatastartbit += newdata.Stride - (newdata.Width * 3);
                }
            }

            bmp.UnlockBits(data);
            bmpnew.UnlockBits(newdata);

            return bmpnew;
        }
        public static Bitmap rotateChanel(ref Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    int r = c.R, g = c.G, b = c.B;
                    int tmp = r; r = g; g = b; b = tmp;
                    bmpnew.SetPixel(i, j, Color.FromArgb(r, g, b));
                }
            }
            return bmpnew;
        }
        public static Bitmap Jitter(ref Bitmap bmp, int winsize)
        {
            Random rand = new Random();
            int winrad = (winsize - 1) / 2;

            int width = bmp.Width, height = bmp.Height;

            Bitmap bmpnew = new Bitmap(width, height);
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) bmpnew.SetPixel(i, j, bmp.GetPixel(i, j));

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int xinc = rand.Next(winsize) - winrad; xinc = i + xinc < 0 ? -i : i + xinc > width - 1 ? width - 1 - i : xinc;
                    int yinc = rand.Next(winsize) - winrad; yinc = j + yinc < 0 ? -j : j + yinc > height - 1 ? height - 1 - j : yinc;
                    bmpnew.SetPixel(i + xinc, j + yinc, bmp.GetPixel(i, j));
                }
            }

            return bmpnew;
        }
        public static Bitmap OilPainting(ref Bitmap image, string mode, int brushSize)
        {
            int width = image.Width, height = image.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);

            int[, ,] newimagematris = new int[width, height, 3];

            int brushHalfSize = brushSize >> 1;

            switch (mode)
            {
                case "bw":
                    for (int i = brushHalfSize; i < width - brushHalfSize; i++)
                    {
                        for (int j = brushHalfSize; j < height - brushHalfSize; j++)
                        {
                            int[, ,] hoods = Matris.Load.NHOODS_3D_(ref imagematris, brushSize, i, j);
                            int[] intensities = Matris.Histogram.Intensity(ref hoods, brushSize, brushSize);
                            int maxintensity = intensities.Max();
                            newimagematris[i, j, 0] = newimagematris[i, j, 1] = newimagematris[i, j, 2] = maxintensity;
                        }
                    }
                    break;
                case "color":
                    int[] r = new int[256];
                    int[] g = new int[256];
                    int[] b = new int[256];
                    int[] intensity = new int[256];
                    for (int i = brushHalfSize; i < width - brushHalfSize; i++)
                    {
                        for (int j = brushHalfSize; j < height - brushHalfSize; j++)
                        {
                            Array.Clear(r, 0, 256);
                            Array.Clear(g, 0, 256);
                            Array.Clear(b, 0, 256);
                            Array.Clear(intensity, 0, 256);
                            int sx = Math.Max(0, i - brushHalfSize),
                                ex = Math.Min(width, i + brushHalfSize),
                                sy = Math.Max(0, j - brushHalfSize),
                                ey = Math.Min(height, j + brushHalfSize);
                            for (int x = sx; x < ex; x++)
                            {
                                for (int y = sy; y < ey; y++)
                                {
                                    double intens =
                                        0.2125 * Convert.ToDouble(imagematris[x, y, 0]) +
                                        0.7154 * Convert.ToDouble(imagematris[x, y, 1]) +
                                        0.0721 * Convert.ToDouble(imagematris[x, y, 2]);
                                    intensity[Convert.ToInt16(intens)]++;
                                    r[Convert.ToInt16(intens)] += imagematris[x, y, 0];
                                    g[Convert.ToInt16(intens)] += imagematris[x, y, 1];
                                    b[Convert.ToInt16(intens)] += imagematris[x, y, 2];
                                }
                            }
                            int maxi = 0;
                            int max_index = 0;
                            for (int m = 0; m < 256; m++)
                            {
                                if (intensity[m] > maxi)
                                {
                                    max_index = m;
                                    maxi = intensity[m];
                                }
                            }
                            int maxintensity = intensity[max_index];
                            newimagematris[i, j, 0] = r[max_index] / maxintensity;
                            newimagematris[i, j, 1] = g[max_index] / maxintensity;
                            newimagematris[i, j, 2] = b[max_index] / maxintensity;
                            //hoods
                        }
                    }
                    break;
            }
            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);


            Bitmap newimage = Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);

            return newimage;
        }
        public static Bitmap musaic(ref Bitmap image, int wSize, int hSize)
        {
            int[, ,] imageMartis = Matris.Load.Matris3DFromeBMP(image);
            int width = image.Width, height = image.Height;
            int[, ,] newImageMatris = new int[width, height, 3];

            //check errore
            if (wSize <= 0 || hSize <= 0 || wSize >= width || hSize >= height) throw new Exception("ERRORE : sizes are not correct!");

            //converting
            int nRiW = width / wSize, nRiH = height / hSize;
            for (int i = 0; i < nRiW; i++)
            {
                for (int j = 0; j < nRiH; j++)
                {
                    int[] avgs = Matris.Math.average(ref imageMartis, width, height, i * wSize, j * hSize, wSize, hSize);
                    Matris.Edit.FillSolid(ref newImageMatris, width, height, i * wSize, j * hSize, wSize, hSize, avgs);
                }
            }
            //گوشه ها
            int Hezafe = height - nRiH * hSize;
            if (Hezafe != 0)
            {
                for (int i = 0; i < nRiW; i++)
                {
                    int[] avgs = Matris.Math.average(ref imageMartis, width, height, i * wSize, height - Hezafe, wSize, Hezafe);
                    Matris.Edit.FillSolid(ref newImageMatris, width, height, i * wSize, height - Hezafe, wSize, Hezafe, avgs);
                }
            }
            int Wezafe = width - nRiW * wSize;
            if (Wezafe != 0)
            {
                for (int j = 0; j < nRiW; j++)
                {
                    int[] avgs = Matris.Math.average(ref imageMartis, width, height, width - Wezafe, j * hSize, Wezafe, wSize);
                    Matris.Edit.FillSolid(ref newImageMatris, width, height, width - Wezafe, j * hSize, Wezafe, wSize, avgs);
                }
            }

            return Matris.Load.BMPfromeMatris3D(ref newImageMatris, width, height);
        }
        public static Bitmap triangle(ref Bitmap image, int squareSize)
        {
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);
            int width = image.Width, height = image.Height;
            int[, ,] newimagematris = new int[width, height, 3];

            int blocksInWidth = width / squareSize;
            int blocksInHeight = height / squareSize;
            int _Count_ = squareSize * squareSize / 4;

            int startA, endA, startB, endB;
            for (int i = 0; i < blocksInWidth; i++)
            {
                for (int j = 0; j < blocksInHeight; j++)
                {
                    int sumr = 0, sumg = 0, sumb = 0;

                    //pass 1, horizontals
                    startA = i * squareSize; endA = startA + (squareSize / 2);
                    if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                    //averaging
                    for (int A = startA; A <= endA; A++)
                    {
                        startB = j * squareSize + (A - startA); endB = ((j + 1) * squareSize) - (A - startA);
                        if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                        for (int B = startB; B <= endB; B++)
                        {
                            sumr += imagematris[A, B, 0]; sumg += imagematris[A, B, 1]; sumb += imagematris[A, B, 2];
                        }//B
                    }//A
                    sumr /= _Count_; sumg /= _Count_; sumb /= _Count_;
                    //rebuilding
                    for (int A = startA; A <= endA; A++)
                    {
                        startB = j * squareSize + (A - startA); endB = ((j + 1) * squareSize) - (A - startA);
                        if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                        for (int B = startB; B <= endB; B++)
                        {
                            newimagematris[A, B, 0] = sumr; newimagematris[A, B, 1] = sumg; newimagematris[A, B, 2] = sumb;
                        }//B
                    }//A

                    //pass 2, horizontal_back
                    sumr = 0; sumg = 0; sumb = 0;
                    startA = endA; endA = startA + (squareSize / 2);
                    if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                    for (int A = startA; A <= endA; A++)
                    {
                        startB = j * squareSize + (squareSize / 2) - (A - startA); endB = j * squareSize + (squareSize / 2) + (A - startA);
                        if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                        for (int B = startB; B <= endB; B++)
                        {
                            sumr += imagematris[A, B, 0]; sumg += imagematris[A, B, 1]; sumb += imagematris[A, B, 2];
                        }//B
                    }//A
                    //rebuilding
                    sumr /= _Count_; sumg /= _Count_; sumb /= _Count_;
                    for (int A = startA; A <= endA; A++)
                    {
                        startB = j * squareSize + (squareSize / 2) - (A - startA); endB = j * squareSize + (squareSize / 2) + (A - startA);
                        if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                        for (int B = startB; B <= endB; B++)
                        {
                            newimagematris[A, B, 0] = sumr; newimagematris[A, B, 1] = sumg; newimagematris[A, B, 2] = sumb;
                        }//B
                    }//A

                    //pass 3, vertical
                    sumr = 0; sumb = 0; sumg = 0;
                    startB = j * squareSize; endB = startB + (squareSize / 2);
                    if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                    for (int B = startB; B <= endB; B++)
                    {
                        startA = i * squareSize + (B - startB); endA = ((i + 1) * squareSize) - (B - startB);
                        if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                        for (int A = startA; A <= endA; A++)
                        {
                            sumr += imagematris[A, B, 0]; sumg += imagematris[A, B, 1]; sumb += imagematris[A, B, 2];
                        }//a
                    }//b
                    //rebuilding
                    sumr /= _Count_; sumg /= _Count_; sumb /= _Count_;
                    for (int B = startB; B <= endB; B++)
                    {
                        startA = i * squareSize + (B - startB); endA = ((i + 1) * squareSize) - (B - startB);
                        if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                        for (int A = startA; A <= endA; A++)
                        {
                            newimagematris[A, B, 0] = sumr; newimagematris[A, B, 1] = sumg; newimagematris[A, B, 2] = sumb;
                        }//a
                    }//b

                    //pass 4, vertical back
                    sumr = 0; sumb = 0; sumg = 0;
                    startB = endB; endB = startB + (squareSize / 2);
                    if (startB >= height) startB = height - 1; if (endB >= height) endB = height - 1;
                    for (int B = startB; B <= endB; B++)
                    {
                        startA = i * squareSize + (squareSize / 2) - (B - startB); endA = i * squareSize + (squareSize / 2) + (B - startB);
                        if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                        for (int A = startA; A <= endA; A++)
                        {
                            sumr += imagematris[A, B, 0]; sumg += imagematris[A, B, 1]; sumb += imagematris[A, B, 2];
                        }//a
                    }//b
                    //rebuilding
                    sumr /= _Count_; sumg /= _Count_; sumb /= _Count_;
                    for (int B = startB; B <= endB; B++)
                    {
                        startA = i * squareSize + (squareSize / 2) - (B - startB); endA = i * squareSize + (squareSize / 2) + (B - startB);
                        if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                        for (int A = startA; A <= endA; A++)
                        {
                            newimagematris[A, B, 0] = sumr; newimagematris[A, B, 1] = sumg; newimagematris[A, B, 2] = sumb;
                        }//a
                    }//b

                }//j
            }//i

            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);
        }
        public static Bitmap circle(ref Bitmap image, int circleSize, string type)
        {
            int width = image.Width, height = image.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);
            int[, ,] newimagematris = new int[width, height, 3];

            int cirlesInWidth = width / circleSize, circlesInHeight = height / circleSize;
            for (int i = 0; i < cirlesInWidth; i++)
            {
                for (int j = 0; j < circlesInHeight; j++)
                {
                    //pass 1, sum
                    int[] avgs = Matris.Math.average(ref imagematris, width, height, i * circleSize, j * circleSize, circleSize, circleSize);
                    //pass 2, circle calculating
                    int radius =
                        (type == "") ? circleSize / 2 :
                        (type == "resize") ? (avgs.Sum()) / 3 * (circleSize / 2) / 255 : circleSize / 2;
                    int[] circleYs = new int[radius * 2];
                    for (int C = 0; C < radius * 2; C++)
                        circleYs[C] = Convert.ToInt32(Math.Sqrt(Math.Pow(radius, 2) - Math.Pow(C - radius, 2)));
                    //draw circle
                    int startA = ((i + 1) * circleSize) - (circleSize / 2) - radius, endA = ((i + 1) * circleSize) - (circleSize / 2) + radius;
                    if (startA >= width) startA = width - 1; if (endA >= width) endA = width - 1;
                    for (int A = startA; A < endA; A++)
                    {
                        int startB = j * circleSize + (circleSize / 2) - circleYs[A - startA];
                        int endB = j * circleSize + (circleSize / 2) + circleYs[A - startA];
                        for (int B = startB; B < endB; B++)
                        {
                            newimagematris[A, B, 0] = avgs[0]; newimagematris[A, B, 1] = avgs[1]; newimagematris[A, B, 2] = avgs[2];
                        }
                    }
                }//j
            }//i

            return Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);
        }

        public static Bitmap HideText(ref Bitmap image, ref string text)
        {
            Bitmap newimage = new Bitmap(image);
            int w = image.Width, h = image.Height;
            int pixels = w * h;

            int L = text.Length;
            if (L > pixels) throw new Exception("Tetx is very long or image is too small!");

            //2 pixels for saveing tetx size
            Color c = newimage.GetPixel(0, 0);
            newimage.SetPixel(0, 0, Color.FromArgb(L / 256, c.G, c.B));
            newimage.SetPixel(0, 1, Color.FromArgb(L % 256, c.G, c.B));

            int dons = pixels / L - 2;
            int rgb_turn = -1;
            int j = dons;
            for (int i = 0; i < L ; i ++)
            {
                c = newimage.GetPixel(j / h, j % h);

                rgb_turn = (rgb_turn + 1) % 3;
                if (rgb_turn == 0) newimage.SetPixel(j / h, j % h, Color.FromArgb(Convert.ToInt32(text[i]), c.G, c.B));
                else if (rgb_turn == 1) newimage.SetPixel(j / h, j % h, Color.FromArgb(c.R, Convert.ToInt32(text[i]), c.B));
                else if (rgb_turn == 2) newimage.SetPixel(j / h, j % h, Color.FromArgb(c.R, c.G, Convert.ToInt32(text[i]))); 

                j += dons;
            }

            return newimage;
        }
        public static char[] ExtractText(ref Bitmap image)
        {
            Bitmap newimage = new Bitmap(image);
            int w = image.Width, h = image.Height;
            int pixels = w * h;

            //text size
            int tsize = 0;
            tsize = 256 * image.GetPixel(0, 0).R;
            tsize += image.GetPixel(0, 1).R;
            char[] text = new char[tsize];

            int dons = pixels / tsize - 2;
            int rgb_turn = -1;
            int j = dons;
            for (int i = 0; i < tsize ; i++)
            {
                Color c = newimage.GetPixel(j / h, j % h);

                rgb_turn = (rgb_turn + 1) % 3;
                if (rgb_turn == 0) text[i] = Convert.ToChar(newimage.GetPixel(j / h, j % h).R);
                else if (rgb_turn == 1) text[i] = Convert.ToChar(newimage.GetPixel(j / h, j % h).G);
                else if (rgb_turn == 2) text[i] = Convert.ToChar(newimage.GetPixel(j / h, j % h).B); 

                j += dons;
            }

            return text;
        }
    }
}
